/**
 * @file xmc_posif_map.h
 * @date 2016-08-22
 *
 * @cond
 *********************************************************************************************************************
 * XMClib v2.1.16 - XMC Peripheral Driver Library
 *
 * Copyright (c) 2015-2017, Infineon Technologies AG
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,are permitted provided that the
 * following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice, this list of conditions and the following
 * disclaimer.
 *
 * Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following
 * disclaimer in the documentation and/or other materials provided with the distribution.
 *
 * Neither the name of the copyright holders nor the names of its contributors may be used to endorse or promote
 * products derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE  FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY,OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * To improve the quality of the software, users are encouraged to share modifications, enhancements or bug fixes with
 * Infineon Technologies AG dave@infineon.com).
 *********************************************************************************************************************
 *
 * Change History
 * --------------
 *
 * 2015-02-20:
 *     - Initial version
 *
 * @endcond
 */

#ifndef XMC_POSIF_MAP_H
#define XMC_POSIF_MAP_H

#if (UC_DEVICE == XMC1301) && (UC_PACKAGE == VQFN24)
#define POSIF0_IN0_ERU0_PDOUT0	3
#define POSIF0_IN0_P0_13    	1
#define POSIF0_IN0_P1_2     	0
#define POSIF0_IN0_VADC_G1BFL0	2
#define POSIF0_IN1_ERU0_PDOUT1	3
#define POSIF0_IN1_P0_14    	1
#define POSIF0_IN1_P1_1     	0
#define POSIF0_IN1_VADC_G1BFL1	2
#define POSIF0_IN2_ERU0_PDOUT2	3
#define POSIF0_IN2_P0_15    	1
#define POSIF0_IN2_P1_0     	0
#define POSIF0_IN2_VADC_G1BFL2	2
#endif


#if (UC_DEVICE == XMC1301) && (UC_PACKAGE == VQFN40)
#define POSIF0_IN0_ERU0_PDOUT0	3
#define POSIF0_IN0_P0_13    	1
#define POSIF0_IN0_P1_2     	0
#define POSIF0_IN0_VADC_G1BFL0	2
#define POSIF0_IN1_ERU0_PDOUT1	3
#define POSIF0_IN1_P0_14    	1
#define POSIF0_IN1_P1_1     	0
#define POSIF0_IN1_VADC_G1BFL1	2
#define POSIF0_IN2_ERU0_PDOUT2	3
#define POSIF0_IN2_P0_15    	1
#define POSIF0_IN2_P1_0     	0
#define POSIF0_IN2_VADC_G1BFL2	2
#endif


#if (UC_DEVICE == XMC1301) && (UC_PACKAGE == TSSOP16)
#define POSIF0_IN0_ERU0_PDOUT0	3
#define POSIF0_IN0_VADC_G1BFL0	2
#define POSIF0_IN1_ERU0_PDOUT1	3
#define POSIF0_IN1_P0_14    	1
#define POSIF0_IN1_VADC_G1BFL1	2
#define POSIF0_IN2_ERU0_PDOUT2	3
#define POSIF0_IN2_P0_15    	1
#define POSIF0_IN2_VADC_G1BFL2	2
#endif


#if (UC_DEVICE == XMC1301) && (UC_PACKAGE == TSSOP38)
#define POSIF0_IN0_ERU0_PDOUT0	3
#define POSIF0_IN0_P0_13    	1
#define POSIF0_IN0_P1_2     	0
#define POSIF0_IN0_VADC_G1BFL0	2
#define POSIF0_IN1_ERU0_PDOUT1	3
#define POSIF0_IN1_P0_14    	1
#define POSIF0_IN1_P1_1     	0
#define POSIF0_IN1_VADC_G1BFL1	2
#define POSIF0_IN2_ERU0_PDOUT2	3
#define POSIF0_IN2_P0_15    	1
#define POSIF0_IN2_P1_0     	0
#define POSIF0_IN2_VADC_G1BFL2	2
#endif


#if (UC_DEVICE == XMC1302) && (UC_PACKAGE == VQFN24)
#define POSIF0_IN0_ERU0_PDOUT0	3
#define POSIF0_IN0_P0_13    	1
#define POSIF0_IN0_P1_2     	0
#define POSIF0_IN0_VADC_G1BFL0	2
#define POSIF0_IN1_ERU0_PDOUT1	3
#define POSIF0_IN1_P0_14    	1
#define POSIF0_IN1_P1_1     	0
#define POSIF0_IN1_VADC_G1BFL1	2
#define POSIF0_IN2_ERU0_PDOUT2	3
#define POSIF0_IN2_P0_15    	1
#define POSIF0_IN2_P1_0     	0
#define POSIF0_IN2_VADC_G1BFL2	2
#endif


#if (UC_DEVICE == XMC1302) && (UC_PACKAGE == VQFN40)
#define POSIF0_IN0_ERU0_PDOUT0	3
#define POSIF0_IN0_P0_13    	1
#define POSIF0_IN0_P1_2     	0
#define POSIF0_IN0_VADC_G1BFL0	2
#define POSIF0_IN1_ERU0_PDOUT1	3
#define POSIF0_IN1_P0_14    	1
#define POSIF0_IN1_P1_1     	0
#define POSIF0_IN1_VADC_G1BFL1	2
#define POSIF0_IN2_ERU0_PDOUT2	3
#define POSIF0_IN2_P0_15    	1
#define POSIF0_IN2_P1_0     	0
#define POSIF0_IN2_VADC_G1BFL2	2
#endif


#if (UC_DEVICE == XMC1302) && (UC_PACKAGE == TSSOP16)
#define POSIF0_IN0_ERU0_PDOUT0	3
#define POSIF0_IN0_VADC_G1BFL0	2
#define POSIF0_IN1_ERU0_PDOUT1	3
#define POSIF0_IN1_P0_14    	1
#define POSIF0_IN1_VADC_G1BFL1	2
#define POSIF0_IN2_ERU0_PDOUT2	3
#define POSIF0_IN2_P0_15    	1
#define POSIF0_IN2_VADC_G1BFL2	2
#endif


#if (UC_DEVICE == XMC1302) && (UC_PACKAGE == TSSOP28)
#define POSIF0_IN0_ERU0_PDOUT0	3
#define POSIF0_IN0_P0_13    	1
#define POSIF0_IN0_P1_2     	0
#define POSIF0_IN0_VADC_G1BFL0	2
#define POSIF0_IN1_ERU0_PDOUT1	3
#define POSIF0_IN1_P0_14    	1
#define POSIF0_IN1_P1_1     	0
#define POSIF0_IN1_VADC_G1BFL1	2
#define POSIF0_IN2_ERU0_PDOUT2	3
#define POSIF0_IN2_P0_15    	1
#define POSIF0_IN2_P1_0     	0
#define POSIF0_IN2_VADC_G1BFL2	2
#endif


#if (UC_DEVICE == XMC1302) && (UC_PACKAGE == TSSOP38)
#define POSIF0_IN0_ERU0_PDOUT0	3
#define POSIF0_IN0_P0_13    	1
#define POSIF0_IN0_P1_2     	0
#define POSIF0_IN0_VADC_G1BFL0	2
#define POSIF0_IN1_ERU0_PDOUT1	3
#define POSIF0_IN1_P0_14    	1
#define POSIF0_IN1_P1_1     	0
#define POSIF0_IN1_VADC_G1BFL1	2
#define POSIF0_IN2_ERU0_PDOUT2	3
#define POSIF0_IN2_P0_15    	1
#define POSIF0_IN2_P1_0     	0
#define POSIF0_IN2_VADC_G1BFL2	2
#endif


#if (UC_DEVICE == XMC1402) && (UC_PACKAGE == LQFP64)
#define POSIF0_IN0_ERU0_PDOUT0	3
#define POSIF0_IN0_P0_13    	1
#define POSIF0_IN0_P1_2     	0
#define POSIF0_IN0_VADC_G1BFL0	2
#define POSIF0_IN1_ERU0_PDOUT1	3
#define POSIF0_IN1_P0_14    	1
#define POSIF0_IN1_P1_1     	0
#define POSIF0_IN1_VADC_G1BFL1	2
#define POSIF0_IN2_ERU0_PDOUT2	3
#define POSIF0_IN2_P0_15    	1
#define POSIF0_IN2_P1_0     	0
#define POSIF0_IN2_VADC_G1BFL2	2
#define POSIF1_IN0_ERU1_PDOUT0	3
#define POSIF1_IN0_P1_8     	0
#define POSIF1_IN0_P4_1     	1
#define POSIF1_IN0_VADC_G1BFL0	2
#define POSIF1_IN1_ERU1_PDOUT1	3
#define POSIF1_IN1_P1_7     	0
#define POSIF1_IN1_P4_2     	1
#define POSIF1_IN1_VADC_G1BFL1	2
#define POSIF1_IN2_ERU1_PDOUT2	3
#define POSIF1_IN2_P1_6     	0
#define POSIF1_IN2_P4_3     	1
#define POSIF1_IN2_VADC_G1BFL2	2
#endif


#if (UC_DEVICE == XMC1402) && (UC_PACKAGE == VQFN40)
#define POSIF0_IN0_ERU0_PDOUT0	3
#define POSIF0_IN0_P0_13    	1
#define POSIF0_IN0_P1_2     	0
#define POSIF0_IN0_VADC_G1BFL0	2
#define POSIF0_IN1_ERU0_PDOUT1	3
#define POSIF0_IN1_P0_14    	1
#define POSIF0_IN1_P1_1     	0
#define POSIF0_IN1_VADC_G1BFL1	2
#define POSIF0_IN2_ERU0_PDOUT2	3
#define POSIF0_IN2_P0_15    	1
#define POSIF0_IN2_P1_0     	0
#define POSIF0_IN2_VADC_G1BFL2	2
#endif


#if (UC_DEVICE == XMC1402) && (UC_PACKAGE == VQFN48)
#define POSIF0_IN0_ERU0_PDOUT0	3
#define POSIF0_IN0_P0_13    	1
#define POSIF0_IN0_P1_2     	0
#define POSIF0_IN0_VADC_G1BFL0	2
#define POSIF0_IN1_ERU0_PDOUT1	3
#define POSIF0_IN1_P0_14    	1
#define POSIF0_IN1_P1_1     	0
#define POSIF0_IN1_VADC_G1BFL1	2
#define POSIF0_IN2_ERU0_PDOUT2	3
#define POSIF0_IN2_P0_15    	1
#define POSIF0_IN2_P1_0     	0
#define POSIF0_IN2_VADC_G1BFL2	2
#define POSIF1_IN0_ERU1_PDOUT0	3
#define POSIF1_IN0_VADC_G1BFL0	2
#define POSIF1_IN1_ERU1_PDOUT1	3
#define POSIF1_IN1_VADC_G1BFL1	2
#define POSIF1_IN2_ERU1_PDOUT2	3
#define POSIF1_IN2_P1_6     	0
#define POSIF1_IN2_VADC_G1BFL2	2
#endif


#if (UC_DEVICE == XMC1402) && (UC_PACKAGE == VQFN64)
#define POSIF0_IN0_ERU0_PDOUT0	3
#define POSIF0_IN0_P0_13    	1
#define POSIF0_IN0_P1_2     	0
#define POSIF0_IN0_VADC_G1BFL0	2
#define POSIF0_IN1_ERU0_PDOUT1	3
#define POSIF0_IN1_P0_14    	1
#define POSIF0_IN1_P1_1     	0
#define POSIF0_IN1_VADC_G1BFL1	2
#define POSIF0_IN2_ERU0_PDOUT2	3
#define POSIF0_IN2_P0_15    	1
#define POSIF0_IN2_P1_0     	0
#define POSIF0_IN2_VADC_G1BFL2	2
#define POSIF1_IN0_ERU1_PDOUT0	3
#define POSIF1_IN0_P1_8     	0
#define POSIF1_IN0_P4_1     	1
#define POSIF1_IN0_VADC_G1BFL0	2
#define POSIF1_IN1_ERU1_PDOUT1	3
#define POSIF1_IN1_P1_7     	0
#define POSIF1_IN1_P4_2     	1
#define POSIF1_IN1_VADC_G1BFL1	2
#define POSIF1_IN2_ERU1_PDOUT2	3
#define POSIF1_IN2_P1_6     	0
#define POSIF1_IN2_P4_3     	1
#define POSIF1_IN2_VADC_G1BFL2	2
#endif


#if (UC_DEVICE == XMC1402) && (UC_PACKAGE == TSSOP38)
#define POSIF0_IN0_ERU0_PDOUT0	3
#define POSIF0_IN0_P0_13    	1
#define POSIF0_IN0_P1_2     	0
#define POSIF0_IN0_VADC_G1BFL0	2
#define POSIF0_IN1_ERU0_PDOUT1	3
#define POSIF0_IN1_P0_14    	1
#define POSIF0_IN1_P1_1     	0
#define POSIF0_IN1_VADC_G1BFL1	2
#define POSIF0_IN2_ERU0_PDOUT2	3
#define POSIF0_IN2_P0_15    	1
#define POSIF0_IN2_P1_0     	0
#define POSIF0_IN2_VADC_G1BFL2	2
#endif

#if (UC_DEVICE == XMC1404) && (UC_PACKAGE == LQFP64)
#define POSIF0_IN0_ERU0_PDOUT0	3
#define POSIF0_IN0_P0_13    	1
#define POSIF0_IN0_P1_2     	0
#define POSIF0_IN0_VADC_G1BFL0	2
#define POSIF0_IN1_ERU0_PDOUT1	3
#define POSIF0_IN1_P0_14    	1
#define POSIF0_IN1_P1_1     	0
#define POSIF0_IN1_VADC_G1BFL1	2
#define POSIF0_IN2_ERU0_PDOUT2	3
#define POSIF0_IN2_P0_15    	1
#define POSIF0_IN2_P1_0     	0
#define POSIF0_IN2_VADC_G1BFL2	2
#define POSIF1_IN0_ERU1_PDOUT0	3
#define POSIF1_IN0_P1_8     	0
#define POSIF1_IN0_P4_1     	1
#define POSIF1_IN0_VADC_G1BFL0	2
#define POSIF1_IN1_ERU1_PDOUT1	3
#define POSIF1_IN1_P1_7     	0
#define POSIF1_IN1_P4_2     	1
#define POSIF1_IN1_VADC_G1BFL1	2
#define POSIF1_IN2_ERU1_PDOUT2	3
#define POSIF1_IN2_P1_6     	0
#define POSIF1_IN2_P4_3     	1
#define POSIF1_IN2_VADC_G1BFL2	2
#endif


#if (UC_DEVICE == XMC1404) && (UC_PACKAGE == VQFN48)
#define POSIF0_IN0_ERU0_PDOUT0	3
#define POSIF0_IN0_P0_13    	1
#define POSIF0_IN0_P1_2     	0
#define POSIF0_IN0_VADC_G1BFL0	2
#define POSIF0_IN1_ERU0_PDOUT1	3
#define POSIF0_IN1_P0_14    	1
#define POSIF0_IN1_P1_1     	0
#define POSIF0_IN1_VADC_G1BFL1	2
#define POSIF0_IN2_ERU0_PDOUT2	3
#define POSIF0_IN2_P0_15    	1
#define POSIF0_IN2_P1_0     	0
#define POSIF0_IN2_VADC_G1BFL2	2
#define POSIF1_IN0_ERU1_PDOUT0	3
#define POSIF1_IN0_VADC_G1BFL0	2
#define POSIF1_IN1_ERU1_PDOUT1	3
#define POSIF1_IN1_VADC_G1BFL1	2
#define POSIF1_IN2_ERU1_PDOUT2	3
#define POSIF1_IN2_P1_6     	0
#define POSIF1_IN2_VADC_G1BFL2	2
#endif


#if (UC_DEVICE == XMC1404) && (UC_PACKAGE == VQFN64)
#define POSIF0_IN0_ERU0_PDOUT0	3
#define POSIF0_IN0_P0_13    	1
#define POSIF0_IN0_P1_2     	0
#define POSIF0_IN0_VADC_G1BFL0	2
#define POSIF0_IN1_ERU0_PDOUT1	3
#define POSIF0_IN1_P0_14    	1
#define POSIF0_IN1_P1_1     	0
#define POSIF0_IN1_VADC_G1BFL1	2
#define POSIF0_IN2_ERU0_PDOUT2	3
#define POSIF0_IN2_P0_15    	1
#define POSIF0_IN2_P1_0     	0
#define POSIF0_IN2_VADC_G1BFL2	2
#define POSIF1_IN0_ERU1_PDOUT0	3
#define POSIF1_IN0_P1_8     	0
#define POSIF1_IN0_P4_1     	1
#define POSIF1_IN0_VADC_G1BFL0	2
#define POSIF1_IN1_ERU1_PDOUT1	3
#define POSIF1_IN1_P1_7     	0
#define POSIF1_IN1_P4_2     	1
#define POSIF1_IN1_VADC_G1BFL1	2
#define POSIF1_IN2_ERU1_PDOUT2	3
#define POSIF1_IN2_P1_6     	0
#define POSIF1_IN2_P4_3     	1
#define POSIF1_IN2_VADC_G1BFL2	2
#endif

#if (UC_DEVICE == XMC4100) && (UC_PACKAGE == LQFP64)
#define POSIF0_IN0_ERU1_PDOUT0	3
#define POSIF0_IN0_P14_7    	1
#define POSIF0_IN0_P1_3     	0
#define POSIF0_IN0_VADC_G1BFL0	2
#define POSIF0_IN1_ERU1_PDOUT1	3
#define POSIF0_IN1_P14_6    	1
#define POSIF0_IN1_P1_2     	0
#define POSIF0_IN1_VADC_G1BFL1	2
#define POSIF0_IN2_ERU1_PDOUT2	3
#define POSIF0_IN2_P14_5    	1
#define POSIF0_IN2_P1_1     	0
#define POSIF0_IN2_VADC_C0SR0	2
#endif


#if (UC_DEVICE == XMC4100) && (UC_PACKAGE == VQFN48)
#define POSIF0_IN0_ERU1_PDOUT0	3
#define POSIF0_IN0_P14_7    	1
#define POSIF0_IN0_P1_3     	0
#define POSIF0_IN0_VADC_G1BFL0	2
#define POSIF0_IN1_ERU1_PDOUT1	3
#define POSIF0_IN1_P14_6    	1
#define POSIF0_IN1_P1_2     	0
#define POSIF0_IN1_VADC_G1BFL1	2
#define POSIF0_IN2_ERU1_PDOUT2	3
#define POSIF0_IN2_P14_5    	1
#define POSIF0_IN2_P1_1     	0
#define POSIF0_IN2_VADC_C0SR0	2
#endif


#if (UC_DEVICE == XMC4104) && (UC_PACKAGE == LQFP64)
#define POSIF0_IN0_ERU1_PDOUT0	3
#define POSIF0_IN0_P14_7    	1
#define POSIF0_IN0_P1_3     	0
#define POSIF0_IN0_VADC_G1BFL0	2
#define POSIF0_IN1_ERU1_PDOUT1	3
#define POSIF0_IN1_P14_6    	1
#define POSIF0_IN1_P1_2     	0
#define POSIF0_IN1_VADC_G1BFL1	2
#define POSIF0_IN2_ERU1_PDOUT2	3
#define POSIF0_IN2_P14_5    	1
#define POSIF0_IN2_P1_1     	0
#define POSIF0_IN2_VADC_C0SR0	2
#endif


#if (UC_DEVICE == XMC4104) && (UC_PACKAGE == VQFN48)
#define POSIF0_IN0_ERU1_PDOUT0	3
#define POSIF0_IN0_P14_7    	1
#define POSIF0_IN0_P1_3     	0
#define POSIF0_IN0_VADC_G1BFL0	2
#define POSIF0_IN1_ERU1_PDOUT1	3
#define POSIF0_IN1_P14_6    	1
#define POSIF0_IN1_P1_2     	0
#define POSIF0_IN1_VADC_G1BFL1	2
#define POSIF0_IN2_ERU1_PDOUT2	3
#define POSIF0_IN2_P14_5    	1
#define POSIF0_IN2_P1_1     	0
#define POSIF0_IN2_VADC_C0SR0	2
#endif


#if (UC_DEVICE == XMC4108) && (UC_PACKAGE == LQFP64)
#define POSIF0_IN0_ERU1_PDOUT0	3
#define POSIF0_IN0_P14_7    	1
#define POSIF0_IN0_P1_3     	0
#define POSIF0_IN0_VADC_G1BFL0	2
#define POSIF0_IN1_ERU1_PDOUT1	3
#define POSIF0_IN1_P14_6    	1
#define POSIF0_IN1_P1_2     	0
#define POSIF0_IN1_VADC_G1BFL1	2
#define POSIF0_IN2_ERU1_PDOUT2	3
#define POSIF0_IN2_P14_5    	1
#define POSIF0_IN2_P1_1     	0
#define POSIF0_IN2_VADC_C0SR0	2
#endif


#if (UC_DEVICE == XMC4108) && (UC_PACKAGE == VQFN48)
#define POSIF0_IN0_ERU1_PDOUT0	3
#define POSIF0_IN0_P14_7    	1
#define POSIF0_IN0_P1_3     	0
#define POSIF0_IN0_VADC_G1BFL0	2
#define POSIF0_IN1_ERU1_PDOUT1	3
#define POSIF0_IN1_P14_6    	1
#define POSIF0_IN1_P1_2     	0
#define POSIF0_IN1_VADC_G1BFL1	2
#define POSIF0_IN2_ERU1_PDOUT2	3
#define POSIF0_IN2_P14_5    	1
#define POSIF0_IN2_P1_1     	0
#define POSIF0_IN2_VADC_C0SR0	2
#endif


#if (UC_DEVICE == XMC4200) && (UC_PACKAGE == LQFP64)
#define POSIF0_IN0_ERU1_PDOUT0	3
#define POSIF0_IN0_P14_7    	1
#define POSIF0_IN0_P1_3     	0
#define POSIF0_IN0_VADC_G1BFL0	2
#define POSIF0_IN1_ERU1_PDOUT1	3
#define POSIF0_IN1_P14_6    	1
#define POSIF0_IN1_P1_2     	0
#define POSIF0_IN1_VADC_G1BFL1	2
#define POSIF0_IN2_ERU1_PDOUT2	3
#define POSIF0_IN2_P14_5    	1
#define POSIF0_IN2_P1_1     	0
#define POSIF0_IN2_VADC_C0SR0	2
#endif


#if (UC_DEVICE == XMC4200) && (UC_PACKAGE == VQFN48)
#define POSIF0_IN0_ERU1_PDOUT0	3
#define POSIF0_IN0_P14_7    	1
#define POSIF0_IN0_P1_3     	0
#define POSIF0_IN0_VADC_G1BFL0	2
#define POSIF0_IN1_ERU1_PDOUT1	3
#define POSIF0_IN1_P14_6    	1
#define POSIF0_IN1_P1_2     	0
#define POSIF0_IN1_VADC_G1BFL1	2
#define POSIF0_IN2_ERU1_PDOUT2	3
#define POSIF0_IN2_P14_5    	1
#define POSIF0_IN2_P1_1     	0
#define POSIF0_IN2_VADC_C0SR0	2
#endif


#if (UC_DEVICE == XMC4400) && (UC_PACKAGE == LQFP100)
#define POSIF0_IN0_ERU1_PDOUT0	3
#define POSIF0_IN0_P14_7    	1
#define POSIF0_IN0_P1_3     	0
#define POSIF0_IN0_VADC_G1BFL0	2
#define POSIF0_IN1_ERU1_PDOUT1	3
#define POSIF0_IN1_P14_6    	1
#define POSIF0_IN1_P1_2     	0
#define POSIF0_IN1_VADC_G1BFL1	2
#define POSIF0_IN2_ERU1_PDOUT2	3
#define POSIF0_IN2_P14_5    	1
#define POSIF0_IN2_P1_1     	0
#define POSIF0_IN2_VADC_C0SR0	2
#define POSIF1_IN0_ERU1_PDOUT0	3
#define POSIF1_IN0_P2_5     	0
#define POSIF1_IN0_VADC_G1BFL0	2
#define POSIF1_IN1_ERU1_PDOUT1	3
#define POSIF1_IN1_P2_4     	0
#define POSIF1_IN1_VADC_G1BFL1	2
#define POSIF1_IN2_ERU1_PDOUT2	3
#define POSIF1_IN2_P2_3     	0
#define POSIF1_IN2_VADC_C0SR1	2
#endif


#if (UC_DEVICE == XMC4400) && (UC_PACKAGE == LQFP64)
#define POSIF0_IN0_ERU1_PDOUT0	3
#define POSIF0_IN0_P14_7    	1
#define POSIF0_IN0_P1_3     	0
#define POSIF0_IN0_VADC_G1BFL0	2
#define POSIF0_IN1_ERU1_PDOUT1	3
#define POSIF0_IN1_P14_6    	1
#define POSIF0_IN1_P1_2     	0
#define POSIF0_IN1_VADC_G1BFL1	2
#define POSIF0_IN2_ERU1_PDOUT2	3
#define POSIF0_IN2_P14_5    	1
#define POSIF0_IN2_P1_1     	0
#define POSIF0_IN2_VADC_C0SR0	2
#define POSIF1_IN0_ERU1_PDOUT0	3
#define POSIF1_IN0_P2_5     	0
#define POSIF1_IN0_VADC_G1BFL0	2
#define POSIF1_IN1_ERU1_PDOUT1	3
#define POSIF1_IN1_P2_4     	0
#define POSIF1_IN1_VADC_G1BFL1	2
#define POSIF1_IN2_ERU1_PDOUT2	3
#define POSIF1_IN2_P2_3     	0
#define POSIF1_IN2_VADC_C0SR1	2
#endif


#if (UC_DEVICE == XMC4402) && (UC_PACKAGE == LQFP100)
#define POSIF0_IN0_ERU1_PDOUT0	3
#define POSIF0_IN0_P14_7    	1
#define POSIF0_IN0_P1_3     	0
#define POSIF0_IN0_VADC_G1BFL0	2
#define POSIF0_IN1_ERU1_PDOUT1	3
#define POSIF0_IN1_P14_6    	1
#define POSIF0_IN1_P1_2     	0
#define POSIF0_IN1_VADC_G1BFL1	2
#define POSIF0_IN2_ERU1_PDOUT2	3
#define POSIF0_IN2_P14_5    	1
#define POSIF0_IN2_P1_1     	0
#define POSIF0_IN2_VADC_C0SR0	2
#define POSIF1_IN0_ERU1_PDOUT0	3
#define POSIF1_IN0_P2_5     	0
#define POSIF1_IN0_VADC_G1BFL0	2
#define POSIF1_IN1_ERU1_PDOUT1	3
#define POSIF1_IN1_P2_4     	0
#define POSIF1_IN1_VADC_G1BFL1	2
#define POSIF1_IN2_ERU1_PDOUT2	3
#define POSIF1_IN2_P2_3     	0
#define POSIF1_IN2_VADC_C0SR1	2
#endif


#if (UC_DEVICE == XMC4402) && (UC_PACKAGE == LQFP64)
#define POSIF0_IN0_ERU1_PDOUT0	3
#define POSIF0_IN0_P14_7    	1
#define POSIF0_IN0_P1_3     	0
#define POSIF0_IN0_VADC_G1BFL0	2
#define POSIF0_IN1_ERU1_PDOUT1	3
#define POSIF0_IN1_P14_6    	1
#define POSIF0_IN1_P1_2     	0
#define POSIF0_IN1_VADC_G1BFL1	2
#define POSIF0_IN2_ERU1_PDOUT2	3
#define POSIF0_IN2_P14_5    	1
#define POSIF0_IN2_P1_1     	0
#define POSIF0_IN2_VADC_C0SR0	2
#define POSIF1_IN0_ERU1_PDOUT0	3
#define POSIF1_IN0_P2_5     	0
#define POSIF1_IN0_VADC_G1BFL0	2
#define POSIF1_IN1_ERU1_PDOUT1	3
#define POSIF1_IN1_P2_4     	0
#define POSIF1_IN1_VADC_G1BFL1	2
#define POSIF1_IN2_ERU1_PDOUT2	3
#define POSIF1_IN2_P2_3     	0
#define POSIF1_IN2_VADC_C0SR1	2
#endif


#if (UC_DEVICE == XMC4500) && (UC_PACKAGE == BGA144)
#define POSIF0_IN0_ERU1_PDOUT0	3
#define POSIF0_IN0_P14_7    	1
#define POSIF0_IN0_P1_3     	0
#define POSIF0_IN0_VADC_G1BFL0	2
#define POSIF0_IN0_VADC_G1BFL0	2
#define POSIF0_IN1_ERU1_PDOUT1	3
#define POSIF0_IN1_P14_6    	1
#define POSIF0_IN1_P1_2     	0
#define POSIF0_IN1_VADC_G1BFL1	2
#define POSIF0_IN1_VADC_G1BFL1	2
#define POSIF0_IN2_ERU1_PDOUT2	3
#define POSIF0_IN2_P14_5    	1
#define POSIF0_IN2_P1_1     	0
#define POSIF0_IN2_VADC_C0SR0	2
#define POSIF1_IN0_ERU1_PDOUT0	3
#define POSIF1_IN0_P2_5     	0
#define POSIF1_IN0_P3_10    	1
#define POSIF1_IN0_VADC_G1BFL0	2
#define POSIF1_IN0_VADC_G1BFL0	2
#define POSIF1_IN1_ERU1_PDOUT1	3
#define POSIF1_IN1_P2_4     	0
#define POSIF1_IN1_P3_9     	1
#define POSIF1_IN1_VADC_G1BFL1	2
#define POSIF1_IN1_VADC_G1BFL1	2
#define POSIF1_IN2_ERU1_PDOUT2	3
#define POSIF1_IN2_P2_3     	0
#define POSIF1_IN2_P3_8     	1
#define POSIF1_IN2_VADC_C0SR1	2
#endif


#if (UC_DEVICE == XMC4500) && (UC_PACKAGE == LQFP100)
#define POSIF0_IN0_ERU1_PDOUT0	3
#define POSIF0_IN0_P14_7    	1
#define POSIF0_IN0_P1_3     	0
#define POSIF0_IN0_VADC_G1BFL0	2
#define POSIF0_IN0_VADC_G1BFL0	2
#define POSIF0_IN1_ERU1_PDOUT1	3
#define POSIF0_IN1_P14_6    	1
#define POSIF0_IN1_P1_2     	0
#define POSIF0_IN1_VADC_G1BFL1	2
#define POSIF0_IN1_VADC_G1BFL1	2
#define POSIF0_IN2_ERU1_PDOUT2	3
#define POSIF0_IN2_P14_5    	1
#define POSIF0_IN2_P1_1     	0
#define POSIF0_IN2_VADC_C0SR0	2
#define POSIF1_IN0_ERU1_PDOUT0	3
#define POSIF1_IN0_P2_5     	0
#define POSIF1_IN0_VADC_G1BFL0	2
#define POSIF1_IN0_VADC_G1BFL0	2
#define POSIF1_IN1_ERU1_PDOUT1	3
#define POSIF1_IN1_P2_4     	0
#define POSIF1_IN1_VADC_G1BFL1	2
#define POSIF1_IN1_VADC_G1BFL1	2
#define POSIF1_IN2_ERU1_PDOUT2	3
#define POSIF1_IN2_P2_3     	0
#define POSIF1_IN2_VADC_C0SR1	2
#endif


#if (UC_DEVICE == XMC4500) && (UC_PACKAGE == LQFP144)
#define POSIF0_IN0_ERU1_PDOUT0	3
#define POSIF0_IN0_P14_7    	1
#define POSIF0_IN0_P1_3     	0
#define POSIF0_IN0_VADC_G1BFL0	2
#define POSIF0_IN0_VADC_G1BFL0	2
#define POSIF0_IN1_ERU1_PDOUT1	3
#define POSIF0_IN1_P14_6    	1
#define POSIF0_IN1_P1_2     	0
#define POSIF0_IN1_VADC_G1BFL1	2
#define POSIF0_IN1_VADC_G1BFL1	2
#define POSIF0_IN2_ERU1_PDOUT2	3
#define POSIF0_IN2_P14_5    	1
#define POSIF0_IN2_P1_1     	0
#define POSIF0_IN2_VADC_C0SR0	2
#define POSIF1_IN0_ERU1_PDOUT0	3
#define POSIF1_IN0_P2_5     	0
#define POSIF1_IN0_P3_10    	1
#define POSIF1_IN0_VADC_G1BFL0	2
#define POSIF1_IN0_VADC_G1BFL0	2
#define POSIF1_IN1_ERU1_PDOUT1	3
#define POSIF1_IN1_P2_4     	0
#define POSIF1_IN1_P3_9     	1
#define POSIF1_IN1_VADC_G1BFL1	2
#define POSIF1_IN1_VADC_G1BFL1	2
#define POSIF1_IN2_ERU1_PDOUT2	3
#define POSIF1_IN2_P2_3     	0
#define POSIF1_IN2_P3_8     	1
#define POSIF1_IN2_VADC_C0SR1	2
#endif


#if (UC_DEVICE == XMC4502) && (UC_PACKAGE == LQFP100)
#define POSIF0_IN0_ERU1_PDOUT0	3
#define POSIF0_IN0_P14_7    	1
#define POSIF0_IN0_P1_3     	0
#define POSIF0_IN0_VADC_G1BFL0	2
#define POSIF0_IN0_VADC_G1BFL0	2
#define POSIF0_IN1_ERU1_PDOUT1	3
#define POSIF0_IN1_P14_6    	1
#define POSIF0_IN1_P1_2     	0
#define POSIF0_IN1_VADC_G1BFL1	2
#define POSIF0_IN1_VADC_G1BFL1	2
#define POSIF0_IN2_ERU1_PDOUT2	3
#define POSIF0_IN2_P14_5    	1
#define POSIF0_IN2_P1_1     	0
#define POSIF0_IN2_VADC_C0SR0	2
#define POSIF1_IN0_ERU1_PDOUT0	3
#define POSIF1_IN0_P2_5     	0
#define POSIF1_IN0_VADC_G1BFL0	2
#define POSIF1_IN0_VADC_G1BFL0	2
#define POSIF1_IN1_ERU1_PDOUT1	3
#define POSIF1_IN1_P2_4     	0
#define POSIF1_IN1_VADC_G1BFL1	2
#define POSIF1_IN1_VADC_G1BFL1	2
#define POSIF1_IN2_ERU1_PDOUT2	3
#define POSIF1_IN2_P2_3     	0
#define POSIF1_IN2_VADC_C0SR1	2
#endif


#if (UC_DEVICE == XMC4504) && (UC_PACKAGE == LQFP100)
#define POSIF0_IN0_ERU1_PDOUT0	3
#define POSIF0_IN0_P14_7    	1
#define POSIF0_IN0_P1_3     	0
#define POSIF0_IN0_VADC_G1BFL0	2
#define POSIF0_IN0_VADC_G1BFL0	2
#define POSIF0_IN1_ERU1_PDOUT1	3
#define POSIF0_IN1_P14_6    	1
#define POSIF0_IN1_P1_2     	0
#define POSIF0_IN1_VADC_G1BFL1	2
#define POSIF0_IN1_VADC_G1BFL1	2
#define POSIF0_IN2_ERU1_PDOUT2	3
#define POSIF0_IN2_P14_5    	1
#define POSIF0_IN2_P1_1     	0
#define POSIF0_IN2_VADC_C0SR0	2
#define POSIF1_IN0_ERU1_PDOUT0	3
#define POSIF1_IN0_P2_5     	0
#define POSIF1_IN0_VADC_G1BFL0	2
#define POSIF1_IN0_VADC_G1BFL0	2
#define POSIF1_IN1_ERU1_PDOUT1	3
#define POSIF1_IN1_P2_4     	0
#define POSIF1_IN1_VADC_G1BFL1	2
#define POSIF1_IN1_VADC_G1BFL1	2
#define POSIF1_IN2_ERU1_PDOUT2	3
#define POSIF1_IN2_P2_3     	0
#define POSIF1_IN2_VADC_C0SR1	2
#endif


#if (UC_DEVICE == XMC4504) && (UC_PACKAGE == LQFP144)
#define POSIF0_IN0_ERU1_PDOUT0	3
#define POSIF0_IN0_P14_7    	1
#define POSIF0_IN0_P1_3     	0
#define POSIF0_IN0_VADC_G1BFL0	2
#define POSIF0_IN0_VADC_G1BFL0	2
#define POSIF0_IN1_ERU1_PDOUT1	3
#define POSIF0_IN1_P14_6    	1
#define POSIF0_IN1_P1_2     	0
#define POSIF0_IN1_VADC_G1BFL1	2
#define POSIF0_IN1_VADC_G1BFL1	2
#define POSIF0_IN2_ERU1_PDOUT2	3
#define POSIF0_IN2_P14_5    	1
#define POSIF0_IN2_P1_1     	0
#define POSIF0_IN2_VADC_C0SR0	2
#define POSIF1_IN0_ERU1_PDOUT0	3
#define POSIF1_IN0_P2_5     	0
#define POSIF1_IN0_P3_10    	1
#define POSIF1_IN0_VADC_G1BFL0	2
#define POSIF1_IN0_VADC_G1BFL0	2
#define POSIF1_IN1_ERU1_PDOUT1	3
#define POSIF1_IN1_P2_4     	0
#define POSIF1_IN1_P3_9     	1
#define POSIF1_IN1_VADC_G1BFL1	2
#define POSIF1_IN1_VADC_G1BFL1	2
#define POSIF1_IN2_ERU1_PDOUT2	3
#define POSIF1_IN2_P2_3     	0
#define POSIF1_IN2_P3_8     	1
#define POSIF1_IN2_VADC_C0SR1	2
#endif


#if (UC_DEVICE == XMC4700) && (UC_PACKAGE == BGA196)
#define POSIF0_IN0_ERU1_PDOUT0	3
#define POSIF0_IN0_P14_7    	1
#define POSIF0_IN0_P1_3     	0
#define POSIF0_IN0_VADC_G1BFL0	2
#define POSIF0_IN1_ERU1_PDOUT1	3
#define POSIF0_IN1_P14_6    	1
#define POSIF0_IN1_P1_2     	0
#define POSIF0_IN1_VADC_G1BFL1	2
#define POSIF0_IN2_ERU1_PDOUT2	3
#define POSIF0_IN2_P14_5    	1
#define POSIF0_IN2_P1_1     	0
#define POSIF0_IN2_VADC_C0SR0	2
#define POSIF1_IN0_ERU1_PDOUT0	3
#define POSIF1_IN0_P2_5     	0
#define POSIF1_IN0_P3_10    	1
#define POSIF1_IN0_VADC_G1BFL0	2
#define POSIF1_IN1_ERU1_PDOUT1	3
#define POSIF1_IN1_P2_4     	0
#define POSIF1_IN1_P3_9     	1
#define POSIF1_IN1_VADC_G1BFL1	2
#define POSIF1_IN2_ERU1_PDOUT2	3
#define POSIF1_IN2_P2_3     	0
#define POSIF1_IN2_P3_8     	1
#define POSIF1_IN2_VADC_C0SR1	2
#endif


#if (UC_DEVICE == XMC4700) && (UC_PACKAGE == LQFP100)
#define POSIF0_IN0_ERU1_PDOUT0	3
#define POSIF0_IN0_P14_7    	1
#define POSIF0_IN0_P1_3     	0
#define POSIF0_IN0_VADC_G1BFL0	2
#define POSIF0_IN1_ERU1_PDOUT1	3
#define POSIF0_IN1_P14_6    	1
#define POSIF0_IN1_P1_2     	0
#define POSIF0_IN1_VADC_G1BFL1	2
#define POSIF0_IN2_ERU1_PDOUT2	3
#define POSIF0_IN2_P14_5    	1
#define POSIF0_IN2_P1_1     	0
#define POSIF0_IN2_VADC_C0SR0	2
#define POSIF1_IN0_ERU1_PDOUT0	3
#define POSIF1_IN0_P2_5     	0
#define POSIF1_IN0_VADC_G1BFL0	2
#define POSIF1_IN1_ERU1_PDOUT1	3
#define POSIF1_IN1_P2_4     	0
#define POSIF1_IN1_VADC_G1BFL1	2
#define POSIF1_IN2_ERU1_PDOUT2	3
#define POSIF1_IN2_P2_3     	0
#define POSIF1_IN2_VADC_C0SR1	2
#endif


#if (UC_DEVICE == XMC4700) && (UC_PACKAGE == LQFP144)
#define POSIF0_IN0_ERU1_PDOUT0	3
#define POSIF0_IN0_P14_7    	1
#define POSIF0_IN0_P1_3     	0
#define POSIF0_IN0_VADC_G1BFL0	2
#define POSIF0_IN1_ERU1_PDOUT1	3
#define POSIF0_IN1_P14_6    	1
#define POSIF0_IN1_P1_2     	0
#define POSIF0_IN1_VADC_G1BFL1	2
#define POSIF0_IN2_ERU1_PDOUT2	3
#define POSIF0_IN2_P14_5    	1
#define POSIF0_IN2_P1_1     	0
#define POSIF0_IN2_VADC_C0SR0	2
#define POSIF1_IN0_ERU1_PDOUT0	3
#define POSIF1_IN0_P2_5     	0
#define POSIF1_IN0_P3_10    	1
#define POSIF1_IN0_VADC_G1BFL0	2
#define POSIF1_IN1_ERU1_PDOUT1	3
#define POSIF1_IN1_P2_4     	0
#define POSIF1_IN1_P3_9     	1
#define POSIF1_IN1_VADC_G1BFL1	2
#define POSIF1_IN2_ERU1_PDOUT2	3
#define POSIF1_IN2_P2_3     	0
#define POSIF1_IN2_P3_8     	1
#define POSIF1_IN2_VADC_C0SR1	2
#endif


#if (UC_DEVICE == XMC4800) && (UC_PACKAGE == BGA196)
#define POSIF0_IN0_ERU1_PDOUT0	3
#define POSIF0_IN0_P14_7    	1
#define POSIF0_IN0_P1_3     	0
#define POSIF0_IN0_VADC_G1BFL0	2
#define POSIF0_IN1_ERU1_PDOUT1	3
#define POSIF0_IN1_P14_6    	1
#define POSIF0_IN1_P1_2     	0
#define POSIF0_IN1_VADC_G1BFL1	2
#define POSIF0_IN2_ERU1_PDOUT2	3
#define POSIF0_IN2_P14_5    	1
#define POSIF0_IN2_P1_1     	0
#define POSIF0_IN2_VADC_C0SR0	2
#define POSIF1_IN0_ERU1_PDOUT0	3
#define POSIF1_IN0_P2_5     	0
#define POSIF1_IN0_P3_10    	1
#define POSIF1_IN0_VADC_G1BFL0	2
#define POSIF1_IN1_ERU1_PDOUT1	3
#define POSIF1_IN1_P2_4     	0
#define POSIF1_IN1_P3_9     	1
#define POSIF1_IN1_VADC_G1BFL1	2
#define POSIF1_IN2_ERU1_PDOUT2	3
#define POSIF1_IN2_P2_3     	0
#define POSIF1_IN2_P3_8     	1
#define POSIF1_IN2_VADC_C0SR1	2
#endif


#if (UC_DEVICE == XMC4800) && (UC_PACKAGE == LQFP100)
#define POSIF0_IN0_ERU1_PDOUT0	3
#define POSIF0_IN0_P14_7    	1
#define POSIF0_IN0_P1_3     	0
#define POSIF0_IN0_VADC_G1BFL0	2
#define POSIF0_IN1_ERU1_PDOUT1	3
#define POSIF0_IN1_P14_6    	1
#define POSIF0_IN1_P1_2     	0
#define POSIF0_IN1_VADC_G1BFL1	2
#define POSIF0_IN2_ERU1_PDOUT2	3
#define POSIF0_IN2_P14_5    	1
#define POSIF0_IN2_P1_1     	0
#define POSIF0_IN2_VADC_C0SR0	2
#define POSIF1_IN0_ERU1_PDOUT0	3
#define POSIF1_IN0_P2_5     	0
#define POSIF1_IN0_VADC_G1BFL0	2
#define POSIF1_IN1_ERU1_PDOUT1	3
#define POSIF1_IN1_P2_4     	0
#define POSIF1_IN1_VADC_G1BFL1	2
#define POSIF1_IN2_ERU1_PDOUT2	3
#define POSIF1_IN2_P2_3     	0
#define POSIF1_IN2_VADC_C0SR1	2
#endif


#if (UC_DEVICE == XMC4800) && (UC_PACKAGE == LQFP144)
#define POSIF0_IN0_ERU1_PDOUT0	3
#define POSIF0_IN0_P14_7    	1
#define POSIF0_IN0_P1_3     	0
#define POSIF0_IN0_VADC_G1BFL0	2
#define POSIF0_IN1_ERU1_PDOUT1	3
#define POSIF0_IN1_P14_6    	1
#define POSIF0_IN1_P1_2     	0
#define POSIF0_IN1_VADC_G1BFL1	2
#define POSIF0_IN2_ERU1_PDOUT2	3
#define POSIF0_IN2_P14_5    	1
#define POSIF0_IN2_P1_1     	0
#define POSIF0_IN2_VADC_C0SR0	2
#define POSIF1_IN0_ERU1_PDOUT0	3
#define POSIF1_IN0_P2_5     	0
#define POSIF1_IN0_P3_10    	1
#define POSIF1_IN0_VADC_G1BFL0	2
#define POSIF1_IN1_ERU1_PDOUT1	3
#define POSIF1_IN1_P2_4     	0
#define POSIF1_IN1_P3_9     	1
#define POSIF1_IN1_VADC_G1BFL1	2
#define POSIF1_IN2_ERU1_PDOUT2	3
#define POSIF1_IN2_P2_3     	0
#define POSIF1_IN2_P3_8     	1
#define POSIF1_IN2_VADC_C0SR1	2
#endif

#endif /* XMC_POSIF_MAP_H */
